% k-Wave Toolbox for the time domain simulation of acoustic wave fields
% Version B.0.2 (second beta release)
% Released: January 2010
% Authors: Bradley Treeby and Ben Cox    
%
% See k-Wave Toolbox in help menu for description and examples.
% Type "help <command-name>" for documentation on individual commands.
% -----------------------------------------------------------------
%
% Wave Propagation
%   kspaceFirstOrder1D  - 1D time-domain simulation of wave propagation
%   kspaceFirstOrder2D  - 2D time-domain simulation of wave propagation
%   kspaceFirstOrder3D  - 3D time-domain simulation of wave propagation
%
% Image Reconstruction
%   kspaceLineRecon     - 2D linear FFT reconstruction
%   kspacePlaneRecon    - 3D planar FFT reconstruction
%
% Geometry Creation
%   makeBall            - Create a binary map of filled ball within a 3D grid
%   makeCartCircle      - Create a 2D Cartesian circle or arc
%   makeCartSphere      - Create a 3D Cartesian sphere
%   makeCircle          - Create a binary map of a circle within a 2D grid
%   makeDisc            - Create a binary map of a filled disc within a 2D grid
%   makeSphere          - Create a binary map of a sphere within a 3D grid
%
% Absorption
%   attenuationWater    - Calculate ultrasound attenuation in distilled water
%   db2neper            - Convert decibels to nepers
%   neper2db            - Convert nepers to decibels
%   powerLawKramersKronig - Calculate dispersion for power law absorption
%
% Grid Utilities
%   cart2grid           - Interpolate a set of Cartesian points onto a binary grid
%   grid2cart           - Return the Cartesian coordinates of the non-zero points of a binary grid
%   interpCartData      - Interpolate data from a Cartesian to a binary sensor mask
%   loadImage           - Load an image file
%   makeGrid            - Create k-space grid structure
%   numDim              - Return the number of matrix dimensions
%   resize              - Resize a matrix using interp2
%   unmaskSensorData    - Reorder data recorded using a binary sensor mask
% 
% Other Utilities
%   filterTimeSeries    - Filter signal using the Kaiser windowing method
%   flyThrough          - Display a three-dimensional matrix slice by slice
%   getColorMap         - Return default k-Wave color map
%   getkWavePath        - Return pathname to the k-Wave Toolbox
%   makeTime            - Create an evenly spaced array of time points
%   scaleSI             - Scale a number to nearest SI unit prefix
%   scaleTime           - Convert seconds to hours, minutes, and seconds
%   speedSoundWater     - Calculate the speed of sound in water with temperature
%   spectrum            - Compute the single sided amplitude and phase spectrums
%   smooth              - Smooth a matrix
%   toneBurst           - Create an enveloped single frequency tone burst